/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.structures;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import pregenerator.common.structures.StructureRef;

public class StructureTracker {
    String name;
    Set<StructureRef> references = new ObjectLinkedOpenHashSet();

    public StructureTracker(CompoundTag nbt) {
        this.name = nbt.m_128461_("name");
        ListTag list = nbt.m_128437_("references", 11);
        int m = list.size();
        for (int i = 0; i < m; ++i) {
            this.references.add(new StructureRef(this.name, list.m_128767_(i)));
        }
    }

    public StructureTracker(String name) {
        this.name = name;
    }

    public synchronized void addStructure(StructureStart start) {
        this.references.add(new StructureRef(this.name, start));
    }

    public String getName() {
        return this.name;
    }

    public synchronized Set<StructureRef> getReferences() {
        return this.references;
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("name", this.name);
        ListTag list = new ListTag();
        for (StructureRef ref : this.references) {
            list.add((Object)new IntArrayTag(ref.write()));
        }
        nbt.m_128365_("references", (Tag)list);
        return nbt;
    }
}

